/*------------------------------------------------------------------------------*
/// Modification Log:
/// EJP 2006-10-23 v8.0499 QA70-8741 THEME_ACCESS_COL_CUSTOM_DATE_FORMAT
/// Jasmine 11/10/06 APPLY_OPTION_TO_ALL_RIGHT_COL
/// Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT
/// ML 12/7/2006 COLUMN_LABELS_STRINGS
/// Jasmine 12/08/06 ADD_USER_INFO_TAB
/// Jasmine 01/29/07 QA70-9287 EDIT_USER_TREE
///	Jake 04/18/07 ADD_FIRST_AND_LAST_BUTTON
///	Jake 04/19/07 ADD_FIRST_AND_LAST_BUTTON_FOR_MAT
 *	Folger 01/15/08 CENTRALIZE_CODE_OF_APPLY_FORMAT								*
 *	Kyle 09/24/08 SET_NO_NEED_TO_LOCALIZE										*
 *	Kyle 11/06/2008 QA80-12531 PROVIDE_HINT_FOR_CUSTOM_DATE_FORMAT_IN_WKS_COL_PROPERTIES_DIALOG
 *	Kyle 12/08/2008 CHECK_IF_RANGE_SELECTED_DIFFERENT_FROM_FORMULA_RANGE		*
 *	Kyle 12/31/2008 QA70-12890-P3 IMPORVE_CUSTOM_LIST_AFTER_USER_ENTERED_AND_RUN_SUCCESSFULLY_TO_ORIGIN_INI
 *	Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
 *	Kyle 04/30/2009 SUPPORT_DEFINING_VARIABLES_IN_SET_VALUES_DIALOG				*
 * Kenny 06/01/2009 DEFINE_SIGNIFICANT_DIGITS_MACROS_FOR_USE_OF_OC_LEVEL		*
 *	Kyle 07/14/2009 QA80-13746 SHOWING_BOTH_LN_AND_SN_WITH_STANDARD_NOTATION_IN_THE_MENU_OF_SET_COLUMN_VALUE_DLG
 *	CPY 7/18/09 QA80-13746 SCV_COL_FX_MENU_SHOW_SN_LN_CLEANUP					*
 *	Kyle 07/27/2009 QA80-13746-P5 CONSIDER_MAT_IN_COL_MAT_MENU					*
 *	Kyle 07/28/2009 QA80-13951 UPPER_CASE_H_FOR_24_HOURS_SYSTEM_AND_LOWER_CASE_H_FOR_12_HOURS_SYSTEM
 *	Sophy 8/7/2009 QA80-14101 SET_GETN_NODES_AS_UNDEFINED_WHEN_SEL_MULTI_COLS_WITH_DIFF_PROPERTY
 *	Sophy 9/9/2009 INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
 *	Kenny 09/15/2009 QA81-14241 SET_COL_VAL_DLG_NEED_REMEMBER_VAR_INDICES_INTO_EACH_COL*
 *	Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES						*
 *	Sophy 12/19/2009 QA80-14101 CENTRALIZE_CODE_CHECK_MULT_COLS_SAME_PROPERTIES	*
 *	Hong 02/03/10 QA80-15063 COL_PROPS_DLG_ADD_FILE_INFO						*
 *------------------------------------------------------------------------------*/
#ifndef _DATA_OB_MANAGER_H_
#define _DATA_OB_MANAGER_H_

enum {
	DATAOB_COL_SEL_CONTIGUOUS 		= 0, // contiguous
	DATAOB_COL_SEL_DISCONTIGUOUS
};

#define STR_LT_VAR_APPLY_FORMAT 	"_IsApplyFormat"	///DG 8/26/05 AVOID_APPLY_FORMAT_TRIGGER_LAYER_CHANGE

///Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
///Kyle 12/31/2008 QA70-12890-P3 IMPORVE_CUSTOM_LIST_AFTER_USER_ENTERED_AND_RUN_SUCCESSFULLY_TO_ORIGIN_INI
//#define STR_CUSTOM_FORMAT_LIST_FILE				okutil_get_origin_path(ORIGIN_PATH_USER) + STR_ORIGIN_INI_FILE_NAME
//#define STR_CUSTOM_FORMAT_LIST_SECTION			"Column Custom Format List"
//#define STR_CUSTOM_FORMAT_LIST_PREFIX			"CustomFmt"
//#define CUSTOM_FORMAT_LIST_MAX_NUM				10
/////End IMPORVE_CUSTOM_LIST_AFTER_USER_ENTERED_AND_RUN_SUCCESSFULLY_TO_ORIGIN_INI
///End CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT

/// Kenny 09/15/2009 QA81-14241 SET_COL_VAL_DLG_NEED_REMEMBER_VAR_INDICES_INTO_EACH_COL
struct DataObjectVarInfo 
{
	int	nRangeVarCount;
	int	nStringVarCount;
	int	nIntegerVarCount;
	int	nDoubleVarCount;
};
/// End QA81-14241 SET_COL_VAL_DLG_NEED_REMEMBER_VAR_INDICES_INTO_EACH_COL

class DataObjectManager
{
public:
	DataObjectManager(DataObject& ob);
	~DataObjectManager();
	
	bool	GetObject(DataObject& ob){	ob = m_object;	return ob.IsValid();	}			///Kyle 11/23/2009 DEFINE_VARIABLES_FOR_SET_MATRIX_VALUES
	
	bool SetRange(const vector<int>& vnRows, const vector<int>& vnCols, int nColSelWay=DATAOB_COL_SEL_CONTIGUOUS);
	
	//public interface
	virtual bool Attach(DataObject& ob);
	virtual void ConstructTree(TreeNode &tr) {out_str("Base class ConstructTree()");}
	virtual void ConstructInfoTree(TreeNode &tr);
	virtual void ConstructFormatTree(TreeNode &tr);
	virtual void UpdateTreeShown(TreeNode &tr) {;}
	
	virtual void GetTree(TreeNode& trProperties, int nSubBranchID = 0);
	virtual bool SetTree(TreeNode& trProperties, TreeNode &trChange=NULL);
	
	virtual void OnBeforeSettings(TreeNode& tr) {;}
	virtual void OnAfterSettings(TreeNode& tr) {;}
	
//	virtual bool IsSelectionValid(Layer& lay) {return true;}
	virtual void GetSelection(Layer& lay) {;}
	virtual string GetSelectionStr() {return "";}
	
	virtual bool OnAfterValueChange(TreeNode& trRow, int nRow, bool& bUpdateGUI, bool& bInitGUI) {return false;}
	
	virtual void GetAllObjectsLongNames(vector<string>& vsNames) {vsNames.SetSize(0);}
	
	///Kyle 07/14/2009 QA80-13746 SHOWING_BOTH_LN_AND_SN_WITH_STANDARD_NOTATION_IN_THE_MENU_OF_SET_COLUMN_VALUE_DLG
	virtual void GetAllObjectsNames(vector<string>& vsSNames, vector<string>& vsLNames) {vsSNames.SetSize(0);vsLNames.SetSize(0);}
	///END SHOWING_BOTH_LN_AND_SN_WITH_STANDARD_NOTATION_IN_THE_MENU_OF_SET_COLUMN_VALUE_DLG
	virtual	bool GetColumn(Column& col) { return false; }///Sophy 9/9/2009 INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
	///Kyle 12/08/2008 CHECK_IF_RANGE_SELECTED_DIFFERENT_FROM_FORMULA_RANGE
	//virtual string GetFormula() {return "";}
	virtual string GetFormula(vector<int>& vnRows = NULL, vector<int>& vnCols = NULL, int* pnColSelWay = NULL) {return "";}
	///End CHECK_IF_RANGE_SELECTED_DIFFERENT_FROM_FORMULA_RANGE
	virtual int GetFormulaAutoUpdateMode() {return AU_NONE;}
//---- CPY 5/17/06 COL_FORMULA_AUTO_UPDATE_CLEANUP
//	virtual void SetFormulaAutoUpdate(BOOL bOn = true) {;}
//	virtual bool SetFormula(LPCSTR lpcszFormula) {return false;}
	virtual bool SetFormula(LPCSTR lpcszFormula, int nAutoUpdate) 	{return false;}
	virtual bool ExecuteFormula(BOOL bUndo = TRUE)					{return false;}
//----

	/// Kenny 09/15/2009 QA81-14241 SET_COL_VAL_DLG_NEED_REMEMBER_VAR_INDICES_INTO_EACH_COL
	virtual bool SetVarInfo(const DataObjectVarInfo& info);
	virtual bool GetVarInfo(DataObjectVarInfo& info);
	/// End QA81-14241 SET_COL_VAL_DLG_NEED_REMEMBER_VAR_INDICES_INTO_EACH_COL
	
	virtual bool HasPreviousObject() {return false;}
	virtual bool HasNextObject() {return false;}
	virtual void ActivePreviousObject() {;}
	virtual void ActiveNextObject() {;}
	
	//----Jake 04/18/07 ADD_FIRST_AND_LAST_BUTTON
	virtual void ActiveFirstObject(){;}
	virtual void ActiveLastObject(){;}
	//----end ADD_FIRST_AND_LAST_BUTTON
	
	///Kevin 11/15/05 QA70-8292-3 COL_INTERNAL_DATATYPE_COMPLEX_NOT_WORKING
	virtual void ConvertFormatTree(TreeNode& trFmt, bool bToGUI = true);
	///End	COL_INTERNAL_DATATYPE_COMPLEX_NOT_WORKING
	virtual void CopyLabelValues(TreeNode& trGUI){}	///Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT
	virtual bool IsProcessSelChange(Layer& lay) {return true;} //--- CPY 2/20/06 MAT_DIALOG_SHOULD_HAVE_NO_SEL_CHANGE_HANLDING
	virtual bool IsLayerCompatible(const Layer& lay) {return false;}//---- CPY 10/25/06 SWITCH_WIN_BY_SEL_COL_EVENT_PROPER_HANDLE
	///Sophy 14/7/2008 QA80-11759-P1 FIX_AUTO_APPLY_CHANGING_VALUE_ON_IMPORT_NEW_IMAGE_INTO_MATRIX_CONTAINING_PREVIOUS_IMPORTED_IMAGE
	virtual	bool IsDataObjectChanged(const Layer& layer ){return false;}
	///end FIX_AUTO_APPLY_CHANGING_VALUE_ON_IMPORT_NEW_IMAGE_INTO_MATRIX_CONTAINING_PREVIOUS_IMPORTED_IMAGE
	
	virtual int	 GetNumRows(){return 0;}
	///Kyle 07/27/2009 QA80-13746-P5 CONSIDER_MAT_IN_COL_MAT_MENU
	//virtual Worksheet* GetWorksheetPtr() {return NULL;}	//----- CPY 7/18/09 QA80-13746 SCV_COL_FX_MENU_SHOW_SN_LN_CLEANUP
	virtual Datasheet* GetDatasheetPtr() {return NULL;}	//----- CPY 7/18/09 QA80-13746 SCV_COL_FX_MENU_SHOW_SN_LN_CLEANUP
	///End CONSIDER_MAT_IN_COL_MAT_MENU

public:
	void UpdateCustomFormatList(TreeNode& tr);		///Kyle 12/31/2008 QA70-12890-P3 IMPORVE_CUSTOM_LIST_AFTER_USER_ENTERED_AND_RUN_SUCCESSFULLY_TO_ORIGIN_INI
	void GetName(string &strName);
	void GetObjectSettings(TreeNode& trGUI);
	/*
	//common settings
	void SetName(LPCSTR lpcstrName, bool &bCheckUpdateStruct=false, bool bForbidReload=false);
	
	void GetLongName(string &strName);
	void SetLongName(LPCSTR lpcstrName, bool &bCheckUpdateStruct=false, bool bForbidReload=false);
	
	void GetComments(string &strComments);
	void SetComments(LPCSTR lpcstrComments, bool &bCheckUpdateStruct=false, bool bForbidReload=false);
	*/
	bool GetRowRange(int& nBegin, int& nEnd);
	bool GetColRange(int& nBegin, int& nEnd);//----- CPY 5/11/09 QA70-12554 MAT_SET_VALUES_NEED_RANGE_SUPPORT
	//------ Folger 01/15/08 CENTRALIZE_CODE_OF_APPLY_FORMAT
protected:
	bool	ApplySettings(TreeNode &trProp, OriginObject &object);
	//------
	///Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
	/////Kyle 12/31/2008 QA70-12890-P3 IMPORVE_CUSTOM_LIST_AFTER_USER_ENTERED_AND_RUN_SUCCESSFULLY_TO_ORIGIN_INI
	//void saveCustomFormatIni(const vector<string>& vsList);
	//void checkLoadCustomFormatIni(vector<string>& vsList);
	//void clearCustomFormatIni();
	/////End IMPORVE_CUSTOM_LIST_AFTER_USER_ENTERED_AND_RUN_SUCCESSFULLY_TO_ORIGIN_INI
	///End CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
protected:
	vector<int>			m_vnRowRanges;
	vector<int>			m_vnColRanges;
	int					m_nColSelWay;
	
	int					m_nPageType;
	DataObject			m_object;
	
	TreeNode			m_trProperties;
};


#define	CMD_COL_ENUM_NAMES 1	///CPY 11/30/05 for multiple cols

/*

enum
{
	CMD_COL_SHORT_NAMES = 0xDF10,//OC_MENURANGE_BEGIN+CMD_WKS_LAST_ENTRY,
	CMD_COL_LONG_NAMES,
	CMD_COL_UNITS,
	CMD_COL_COMMENT,
	CMD_COL_FORMULA,
	CMD_COL_WIDTH,
	//Designation
	CMD_COL_PLOT_DESIGNATION,
	CMD_COL_FORMAT,
	CMD_COL_DISPLAY,
	CMD_COL_NUMERIC_DISPLAY,
	CMD_COL_SET_DIGITAL,
	CMD_COL_INTERNAL_DATA,
	
	CMD_COL_ENUM_NAMES,	///DG 7/6/05 for multiple cols
	
	//for matrix
	//CMD_MAT_SHORT_NAMES,
	//CMD_MAT_LONG_NAMES,
	//CMD_MAT_COMMENT,
	CMD_MAT_WIDTH,
	CMD_MAT_DIMENSIONS,
	CMD_MAT_COLUMNS,
	CMD_MAT_ROWS,
	CMD_MAT_COORDINATES,
	CMD_MAT_XMIN,
	CMD_MAT_XMAX,
	CMD_MAT_YMIN,
	CMD_MAT_YMAX,
	CMD_MAT_DATA_TYPE,
	CMD_MAT_DATA_FORMAT,
	CMD_MAT_DISPLAY_MODE,
	CMD_MAT_DIGITS,
	
CMD_COL_LAST_ENTRY
};

enum {	PLOTDESIGNATION_X,
		PLOTDESIGNATION_Y,
		PLOTDESIGNATION_Z,
		PLOTDESIGNATION_X_ERROR,
		PLOTDESIGNATION_Y_ERROR,
		PLOTDESIGNATION_LABEL,
		PLOTDESIGNATION_DISREGARD
};
*/

enum {	NUMERIC_DEFAULT_DECIMAL,
		NUMERIC_SET_DECIMAL_PLACES,
		NUMERIC_SET_SIGNIFICANT_DIGITS
};
#define GUI_COLUMNTYPE_TEXT_NUMERIC			6
#define GUI_COLUMN_INTERNAL_DATA_DOUBLE		0	//default double
#define GUI_COLUMN_INTERNAL_DATA_COMPLEX	4
///end USE_GETFORMAT_APPLYFORMAT

#define STR_RIGHT_CLICK_HINT			_L("Right-click on the node to edit")	///Jasmine 02/02/10 SHOW_RIGHT_CLICK_HINT_IN_ONE_ROW_TO_SAVE_SPACE

///DG 7/26/05
#define STR_SHORT_NAME_LABEL			_L("Short Name")
/// ML 12/7/2006 COLUMN_LABELS_STRINGS
//#define STR_LONG_NAME_LABEL				_L("Long Name")
//#define STR_UNIT_LABEL					_L("Units")
//#define STR_COMMENTS_LABEL				_L("Comments")
/// end COLUMN_LABELS_STRINGS
#define STR_FORMULA_LABEL				_L("Formula")
#define STR_WIDTH_LABEL					_L("Column Width")//_L("Cell Width")
#define STR_APPLY_LABEL					_L("Apply to all")	///Jasmine 09/18/06 APPLY_WIDTH_TO_ALL_COL
#define STR_PLOT_DESIGNATION_LABEL		_L("Plot Designation")
#define STR_FORMAT_LABEL				_L("Format")
#define STR_DISPLAY_LABEL				_L("Display")
#define STR_NUMERIC_DISPLAY_LABEL		_L("Digits")
#define STR_DECIMAL_PLACES_LABEL		_L("Decimal Number")
#define STR_SIGNIFICANT_PLACES_LABEL	_L("Significant Digits")
#define STR_INTERNAL_DATA_TYPE_LABEL	_L("Data Type")
#define STR_APPLY_TO_RIGHT_LABEL		_L("Apply to all columns to the right")	///Jasmine 11/10/06 APPLY_OPTION_TO_ALL_RIGHT_COL
///end
/// EJP 2006-10-23 v8.0499 QA70-8741 THEME_ACCESS_COL_CUSTOM_DATE_FORMAT
#define STR_CUSTOM_FORMAT_LABEL			_L("Custom Display") // "Display" to be more clear to user what they are customizing
/// end THEME_ACCESS_COL_CUSTOM_DATE_FORMAT

///---DG 7/15/05
#define STR_COL_DESIGNATION_LIST		_L("X|Y|Z|X Error|Y Error|Label|Disregard|Group|Subject")	///DG 9/14/05 : add Group and Subject
#define STR_COL_FORMAT_LIST				_L("Numeric|Text|Time|Date|Month|Day of Week|Text & Numeric")
#define STR_DATA_DISPLAY_MODE_LIST		_L("Decimal:1000|Scientific:1E3|Engineering:1K|Decimal:1,000")
#define STR_DECIMAL_DIGITS_MODE_LIST	_L("Default Decimal Digits|Set Decimal Places=|Significant Digits=")
///Kevin 11/12/05	QA70-8292-3 MAKE_STRING_CONST
//#define STR_COL_INTERNAL_DATA_LIST		_L("Double(8)|Float(4)|Integer(2)|Long(4)|Complex(16)")
///Kyle 09/24/08 SET_NO_NEED_TO_LOCALIZE
//#define STR_COL_INTERNAL_DATA_LIST		_L("Double(8)|Real(4)|Short(2)|Long(4)|Char(1)|Byte(1)|uShort(2)|uLong(4)|Complex(16)")
#define STR_COL_INTERNAL_DATA_LIST		"Double(8)|Real(4)|Short(2)|Long(4)|Char(1)|Byte(1)|uShort(2)|uLong(4)|Complex(16)"
///End SET_NO_NEED_TO_LOCALIZE
///End MAKE_STRING_CONST
///Kyle 07/28/2009 QA80-13951 UPPER_CASE_H_FOR_24_HOURS_SYSTEM_AND_LOWER_CASE_H_FOR_12_HOURS_SYSTEM
//#define STR_COL_TIME_DISPLAY_LIST		"HH:mm|HH|HH:mm:ss|HH:mm:ss.##|HH pm|HH:mm pm|mm:ss|mm:ss.##|HHmm|HHmmss|HH:mm:ss.###|DDD|DDD:hh|DDD:hh:mm|DDD:hh:mm:ss|DDD:hh:mm:ss.##|DDD:hh:mm:ss.######"
#define STR_COL_TIME_DISPLAY_LIST		"HH:mm|HH|HH:mm:ss|HH:mm:ss.##|hh pm|hh:mm pm|mm:ss|mm:ss.##|HHmm|HHmmss|HH:mm:ss.###|DDD|DDD:HH|DDD:HH:mm|DDD:HH:mm:ss|DDD:HH:mm:ss.##|DDD:HH:mm:ss.######"
///End UPPER_CASE_H_FOR_24_HOURS_SYSTEM_AND_LOWER_CASE_H_FOR_12_HOURS_SYSTEM
#define STR_COL_MONTH_DISPLAY_LIST		_L("Jan|January|J")
#define STR_COL_WEEK_DISPLAY_LIST		_L("Mon|Monday|M")

#define STR_MUL_COLS_DESIGNATION_LIST	"X|Y|Z|Disregard|XYY|XY XY|XYY XYY|XYYY XYYY|X YYErr|XYYErr XYYErr|XYZZ|XYZ XYZ"
///Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
/////Kyle 11/06/2008 QA80-12531 PROVIDE_HINT_FOR_CUSTOM_DATE_FORMAT_IN_WKS_COL_PROPERTIES_DIALOG
//#define STR_CUSTOM_DATE_FORMAT_LIST		"|d'/'M'/'yyyy|yy'-'MM'-'dd|dd'.'MM'.'yyyy|yyyy'/'MM'/'dd|d'/'M'/'yyyy hh':'mm':'ss|dd'.'MM'.'yyyy hh':'mm':'ss|yy'-'MM'-'dd hh':'mm':'ss'.'####|yyyy'/'MM'/'dd hh':'mm':'ss'.'####"
/////End PROVIDE_HINT_FOR_CUSTOM_DATE_FORMAT_IN_WKS_COL_PROPERTIES_DIALOG
///End CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
//DG 7/15/05: Why Matrix data format different from Column format ? 

///Kevin 11/12/05 QA70-8292-3 MAKE_STRING_CONST
//#define STR_MAT_DATA_FORMAT_LIST		_L("Double(8)|Float(4)|Short(2)|Integer(4)|Char(1)|Complex(16)")
///End MAKE_STRING_CONST

///---end

///DG 8/9/05 SETTINGS_RANGE_LIMITS
//#define MAX_SIGNIFICANT_DIGITS   		 15	/// Kenny 06/01/2009 DEFINE_SIGNIFICANT_DIGITS_MACROS_FOR_USE_OF_OC_LEVEL, moved to sys_utils.h
#define MAX_DECIMAL_PLACES   			 12
///end SETTINGS_RANGE_LIMITS
///Jasmine 10/19/06 HIDE_DLG_IF_SEL_INVALID, ColProperties Dlg update for label selection
bool is_wks_sel_valid(Layer& lay, bool bAllowLabel = false, LPCSTR lpcszDebugFrom = NULL);

class ColAccess : public DataObjectManager
{
public:
	ColAccess();
	ColAccess(Column& col);
	ColAccess(Worksheet& wks);
	
	bool IsValid();
	virtual bool Attach(Worksheet &wks, UINT iColNum);
	
	///virtual
//	bool IsSelectionValid(Layer& lay);
	void GetSelection(Layer& lay);
	void GetAllObjectsLongNames(vector<string>& vsNames);
	
	///Kyle 07/14/2009 QA80-13746 SHOWING_BOTH_LN_AND_SN_WITH_STANDARD_NOTATION_IN_THE_MENU_OF_SET_COLUMN_VALUE_DLG
	void GetAllObjectsNames(vector<string>& vsSNames, vector<string>& vsLNames);
	///END SHOWING_BOTH_LN_AND_SN_WITH_STANDARD_NOTATION_IN_THE_MENU_OF_SET_COLUMN_VALUE_DLG
	
	///Sophy 9/9/2009 INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
	//virtual
	bool GetColumn(Column& col)	{ col = m_Col; return col.IsValid(); }
	///end INSERT_VAR_DLG_NEED_TO_KNOW_CUR_SEL_COLUMN_FROM_SET_COL_VALUES_DLG
	bool HasPreviousObject();
	bool HasNextObject();
	void ActivePreviousObject();
	void ActiveNextObject();
	//----Jake 04/18/07 ADD_FIRST_AND_LAST_BUTTON
	void ActiveFirstObject();
	void ActiveLastObject();
	//----end ADD_FIRST_AND_LAST_BUTTON
	int	 GetNumRows(){return m_wks.GetNumRows();}
	
	//virtual
	///Kyle 07/27/2009 QA80-13746-P5 CONSIDER_MAT_IN_COL_MAT_MENU
	//Worksheet* GetWorksheetPtr() {return m_wks? &m_wks:NULL;}	//----- CPY 7/18/09 QA80-13746 SCV_COL_FX_MENU_SHOW_SN_LN_CLEANUP
	virtual Datasheet* GetDatasheetPtr() {return m_wks? &m_wks:NULL;}	//----- CPY 7/18/09 QA80-13746 SCV_COL_FX_MENU_SHOW_SN_LN_CLEANUP
	///End CONSIDER_MAT_IN_COL_MAT_MENU


	//---- CPY 10/25/06 SWITCH_WIN_BY_SEL_COL_EVENT_PROPER_HANDLE
	bool IsLayerCompatible(const Layer& lay)
	{
		Worksheet wks(lay);
		if(wks)
			return true;
		return false;
	}
	//----
	///Sophy 14/7/2008 QA80-11759-P1 FIX_AUTO_APPLY_CHANGING_VALUE_ON_IMPORT_NEW_IMAGE_INTO_MATRIX_CONTAINING_PREVIOUS_IMPORTED_IMAGE
	//virtual
	bool IsDataObjectChanged(const Layer& layer )
	{
		///Sophy 14/7/2008 QA80-11759-P2 FIX_FORMULA_AUTO_APPLY_OVERWRITE_COLUMN_VALUES
		//return true;//temporary code, since this code is called before newly selected column get highlighted, and it's hard to detect column changes
		ASSERT( layer );
		Worksheet	wks( layer );
		if( !is_same_layer( wks, m_wks ) )
			return true;
		
		vector<int>	vnSelIndex;
		wks.GetSelectedColumns( vnSelIndex );
		if( vnSelIndex.GetSize() < 1 )
			return false;
		//vnSelIndex has only one data since SetValue Dialog only allow on column selected
		Column col = wks.Columns( vnSelIndex[0] );
		ASSERT( col );
		if( col.GetIndex() != m_Col.GetIndex() )
			return true;
		
		return false;
		///end FIX_FORMULA_AUTO_APPLY_OVERWRITE_COLUMN_VALUES
	}
	///end FIX_AUTO_APPLY_CHANGING_VALUE_ON_IMPORT_NEW_IMAGE_INTO_MATRIX_CONTAINING_PREVIOUS_IMPORTED_IMAGE
	
protected:
	void ActiveColumn(int nColIndex);
	
protected:
	Worksheet		m_wks;
	Column			m_Col;
};

class ColProperties : public ColAccess
{
public:
	ColProperties();
	ColProperties(Column& col);
	ColProperties(Worksheet& wks);

	//virtual
	void ConstructTree(TreeNode &tr);
	void ConstructEnumTree(TreeNode &tr, bool bShowStopCol = true);	///Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT
	void CopyLabelValues(TreeNode& trGUI);
	void ConstructUserInfoTree(TreeNode &tr, bool bMulti = false);	///Jasmine 12/08/06 ADD_USER_INFO_TAB
	void ConstructFileInfoTree(TreeNode &tr, bool bMulti = false);	/// Hong 02/03/10 QA80-15063 COL_PROPS_DLG_ADD_FILE_INFO
	void ApplyUserInfoTree(TreeNode &tr);	///Jasmine 01/29/07 QA70-9287 EDIT_USER_TREE
	//bool SetTree(TreeNode& trProperties, TreeNode &trChange=NULL);
	void OnBeforeSettings(TreeNode& tr);
	void OnAfterSettings(TreeNode& tr);
	
	void UpdateTreeShown(TreeNode& tr);
	
public:
	bool Attach(Worksheet &wks, UINT iColNum);
	
	virtual void ConstructFormatTree(TreeNode &tr);
	
	virtual void GetUnits(string &strUnit);
	virtual void GetFormula(string &strFormula);
	virtual void GetWidth(string &strWidth);
	virtual void GetPlotDesignation(string &strDesignation);
	virtual void GetFormat(string &strFormat);
	virtual void GetDisplay(string &strDisplay);
	virtual void GetDigitMode(string &strDigitMode);
	virtual void GetDigits(string &strDigits);
	virtual void GetInternalData(string &strInternalData);

	bool IsWrongDataFormat(Column& col);
	
	//virtual 
	bool IsProcessSelChange(Layer& lay); //--- CPY 2/20/06 MAT_DIALOG_SHOULD_HAVE_NO_SEL_CHANGE_HANLDING
	///Jasmine 11/10/06 APPLY_OPTION_TO_ALL_RIGHT_COL
	void EnumColsNamesToRight(LPCSTR lpcszName, int nIndex = 1, int nStop = -1, bool &bCheckUpdateStruct=false, bool bForbidReload=false);///Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT
	virtual bool IsSameNameColumnExist(LPCSTR lpcszColName, bool bOutSideOnly = false, int nStopCol = 0); ///DG DUP_NAME_NOT_ALLOW
	///End APPLY_OPTION_TO_ALL_RIGHT_COL
	/// Hong 01/29/07 MORE_APPLY_OPTION_TO_ALL_RIGHT_COL
	void ChangeColsLabelsToRight(LPCSTR lpcszName, int nIndex = 1, int nStop = -1, bool &bCheckUpdateStruct=false, bool bForbidReload=false, int nLabelType = 0, int nUpdateType = 0);
	/// end MORE_APPLY_OPTION_TO_ALL_RIGHT_COL
protected:
	string GetCurrentDataDisplayList();
	int GetListSize(LPCSTR lpcszList, char ch='|');///Jasmine 03/24/07 MOVE_TO_COL_PROPERTIES
	//void GetSettings(TreeNode& trGUI);
	void RemoveDigitsIfValidInput(TreeNode& tr);
	
	virtual TreeNode GetFormatSettingsNode(TreeNode& tr);
private:
	string get_date_str(time_t &ltime, WORD wFormat);
	
};
///end USE_GETFORMAT_APPLYFORMAT

enum {
	MUL_COLS_DESIGNATION_X,
	MUL_COLS_DESIGNATION_Y,
	MUL_COLS_DESIGNATION_Z,
	MUL_COLS_DESIGNATION_DISREGARD,
	MUL_COLS_DESIGNATION_XYY,
	MUL_COLS_DESIGNATION_XY_XY,
	MUL_COLS_DESIGNATION_XYY_XYY,
	MUL_COLS_DESIGNATION_XYYY_XYYY,
	MUL_COLS_DESIGNATION_XYYERR,
	MUL_COLS_DESIGNATION_XYYERR_XYYERR,
	MUL_COLS_DESIGNATION_XYZZ,
	MUL_COLS_DESIGNATION_XYZ_XYZ
};

///Sophy 12/19/2009 QA80-14101 CENTRALIZE_CODE_CHECK_MULT_COLS_SAME_PROPERTIES
//enumeration for columns properties
enum {
	MULTI_COLS_PROP_WIDTH = 0,
	MULTI_COLS_PROP_FORMAT,
	MULTI_COLS_PROP_DISPLAY,
	MULTI_COLS_PROP_DIGITMODE,
	MULTI_COLS_PROP_DIGITS,
	MULTI_COLS_PROP_INTER_DATA,
	MULTI_COLS_PROP_LONGNAME,
	MULTI_COLS_PROP_UNITS,
	MULTI_COLS_PROP_COMMENTS,
};
///end CENTRALIZE_CODE_CHECK_MULT_COLS_SAME_PROPERTIES
class MulColsProperties : public ColProperties
{
public:
	MulColsProperties();
	MulColsProperties(Column& col);
	MulColsProperties(Worksheet& wks);
	
public:
	bool Attach(Worksheet &wks, UINT iColNum);
	
	//virtual
	void GetTree(TreeNode& trProperties, int nSubBranchID = 0);
	bool SetTree(TreeNode& trProperties, TreeNode &trChange=NULL);
	void OnBeforeSettings(TreeNode& tr);
	void OnAfterSettings(TreeNode& tr);
	bool IsSameNameColumnExist(LPCSTR lpcszColName, bool bOutSideOnly = false, int nStopCol = 0); ///DG DUP_NAME_NOT_ALLOW	///Jasmine 11/10/06 APPLY_OPTION_TO_ALL_RIGHT_COL
	
	///Sophy 12/19/2009 QA80-14101 CENTRALIZE_CODE_CHECK_MULT_COLS_SAME_PROPERTIES
	//bool IsColsSameWidth();
	//bool IsColsSameFormat();
	//bool IsColsSameDisplay();
	//bool IsColsSameDigitMode();
	//bool IsColsSameDigits();
	//bool IsColsSameInternalData();
	/////Sophy 8/7/2009 QA80-14101 SET_GETN_NODES_AS_UNDEFINED_WHEN_SEL_MULTI_COLS_WITH_DIFF_PROPERTY
	//bool IsColsSameLongName();
	//bool IsColsSameUnits();
	//bool IsColsSameComments();
	/////end SET_GETN_NODES_AS_UNDEFINED_WHEN_SEL_MULTI_COLS_WITH_DIFF_PROPERTY
	///end CENTRALIZE_CODE_CHECK_MULT_COLS_SAME_PROPERTIES

	void ConstructTree(TreeNode &tr);

	void SetMulColsDesignation(LPCSTR lpcszDesignation, bool &bCheckUpdateStruct=false, bool bForbidReload=false);
	void EnumColsNames(LPCSTR lpcszName, int nIndex = 1, bool &bCheckUpdateStruct=false, bool bForbidReload=false);///Jasmine 11/29/06 ADD_TAB_FOR_MORE_CONTENT
	/// Hong 01/29/07 MORE_APPLY_OPTION_TO_ALL_RIGHT_COL
	void ChangeColsLabelNames(LPCSTR lpcszName, int nIndex = 1, bool &bCheckUpdateStruct=false, bool bForbidReload=false, int nLabelType = 0, int nUpdateType = 0);
	/// end MORE_APPLY_OPTION_TO_ALL_RIGHT_COL
	string GetSelectionStr();
	
	bool OnAfterValueChange(TreeNode& trRow, int nRow, bool& bUpdateGUI, bool& bInitGUI);
	
protected:
	void UpdateMulColsProperties(TreeNode& tr);
	
	//virtual
	TreeNode GetFormatSettingsNode(TreeNode& tr);
	
private:
	bool attach(uint iColNum);
	bool isMulCols();
	
	int getCurrentDesignation(const vector<string>& vsList);
	string getDesignationStr(int nDesignation);
	//int getListSize(LPCSTR lpcszList, char ch='|');///Jasmine 03/24/07 MOVE_TO_COL_PROPERTIES
	///Sophy 12/19/2009 QA80-14101 CENTRALIZE_CODE_CHECK_MULT_COLS_SAME_PROPERTIES
	bool isColsSameProp(int nPropID);
	///end CENTRALIZE_CODE_CHECK_MULT_COLS_SAME_PROPERTIES
};
#define GUI_MATRIX_INTERNAL_DATA_COMPLEX	5


///set values
class ColumnValues : public ColAccess
{
public:
	ColumnValues();
	ColumnValues(Worksheet& lay);
	~ColumnValues();
	
	//virtual
	bool Attach(DataObject& ob);
	bool IsProcessSelChange(Layer& lay);///Jasmine 04/24/06 SET_COL_VAL_DLG_MODELESS
	///Sophy 9/10/2009 QA80-14297 HIDE_SET_COL_VALS_DLG_WHEN_NO_VALID_DATA_SELECTED
	//virtual
	void GetSelection(Layer& lay);
	///end HIDE_SET_COL_VALS_DLG_WHEN_NO_VALID_DATA_SELECTED
	string GetSelectionStr();
	///Kyle 12/08/2008 CHECK_IF_RANGE_SELECTED_DIFFERENT_FROM_FORMULA_RANGE
	//string GetFormula();
	string GetFormula(vector<int>& vnRows = NULL, vector<int>& vnCols = NULL, int* pnColSelWay = NULL);
	///End CHECK_IF_RANGE_SELECTED_DIFFERENT_FROM_FORMULA_RANGE
//---- CPY 5/17/06 COL_FORMULA_AUTO_UPDATE_CLEANUP
//	bool SetFormula(LPCSTR lpcszFormula);
//	void SetFormulaAutoUpdate(BOOL bOn = true);
	bool SetFormula(LPCSTR lpcszFormula, int nAutoUpdate);
	bool ExecuteFormula(BOOL bUndo = TRUE);
//----
	int GetFormulaAutoUpdateMode();
};


class MatrixObjectAccess : public DataObjectManager
{
public:
	MatrixObjectAccess();
	MatrixObjectAccess(MatrixObject& mo);
	MatrixObjectAccess(MatrixLayer& ml);
	
	//virtual
	void GetSelection(Layer& lay);
	///Jasmine 08/28/06 SHARE_SET_VAL_DLG
	void GetAllObjectsLongNames(vector<string>& vsNames);
	///Kyle 07/14/2009 QA80-13746 SHOWING_BOTH_LN_AND_SN_WITH_STANDARD_NOTATION_IN_THE_MENU_OF_SET_COLUMN_VALUE_DLG
	void GetAllObjectsNames(vector<string>& vsSNames, vector<string>& vsLNames);
	///END SHOWING_BOTH_LN_AND_SN_WITH_STANDARD_NOTATION_IN_THE_MENU_OF_SET_COLUMN_VALUE_DLG
	bool HasPreviousObject();
	bool HasNextObject();
	void ActivePreviousObject(){ m_ml.SetActive(m_ml.GetActive() - 1);}
	void ActiveNextObject(){ m_ml.SetActive(m_ml.GetActive() + 1);}
	//----Jake 04/19/07 ADD_FIRST_AND_LAST_BUTTON_FOR_MAT
	void ActiveFirstObject(){ m_ml.SetActive(0);}
	void ActiveLastObject()
	{
		int nCount=0;
		foreach(MatrixObject mo in m_ml.MatrixObjects)nCount++;
		m_ml.SetActive(nCount-1);
	}
	//----end ADD_FIRST_AND_LAST_BUTTON_FOR_MAT
	///End SHARE_SET_VAL_DLG	
	int	 GetNumRows(){return m_ml.GetNumRows();}
	//---- CPY 10/25/06 SWITCH_WIN_BY_SEL_COL_EVENT_PROPER_HANDLE
	bool IsLayerCompatible(const Layer& lay)
	{
		MatrixLayer ml(lay);
		if(ml)
			return true;
		return false;
	}
	///Kyle 07/27/2009 QA80-13746-P5 CONSIDER_MAT_IN_COL_MAT_MENU
	//virtual
	Datasheet* GetDatasheetPtr() {return m_ml? &m_ml : NULL;}
	///End 
	//----
	///Sophy 14/7/2008 QA80-11759-P1 FIX_AUTO_APPLY_CHANGING_VALUE_ON_IMPORT_NEW_IMAGE_INTO_MATRIX_CONTAINING_PREVIOUS_IMPORTED_IMAGE
	//virtual
	bool IsDataObjectChanged(const Layer& lay )
	{
		ASSERT( lay );
		if( !m_ml )
		{
			MatrixLayer mlayer( lay );
			m_ml = mlayer;
			return true;
		}
		PageBase mpb = m_ml.GetPage();
		PageBase pb = lay.GetPage();
		if( mpb.GetUID() != pb.GetUID() )
			return true;
			
		if( m_ml.GetIndex() != lay.GetIndex() )
			return true;
		
		MatrixLayer mtLayer( lay );
		MatrixObject mtObj = mtLayer.MatrixObjects( mtLayer.GetActive() );
		if( !mtObj.IsValid() || mtObj.GetIndex() != m_mo.GetIndex() )
			return true;
		
		return false;
	}
	///end FIX_AUTO_APPLY_CHANGING_VALUE_ON_IMPORT_NEW_IMAGE_INTO_MATRIX_CONTAINING_PREVIOUS_IMPORTED_IMAGE
	
protected:
	MatrixLayer			m_ml;
	MatrixObject		m_mo;
};

class MatrixObjectProperties : public MatrixObjectAccess
{
public:
	MatrixObjectProperties();
	MatrixObjectProperties(MatrixObject& mo);
	MatrixObjectProperties(MatrixLayer& ml);

	//virtual 
	bool IsProcessSelChange(Layer& lay) {return false;} //--- CPY 2/20/06 MAT_DIALOG_SHOULD_HAVE_NO_SEL_CHANGE_HANLDING

	//virtual
	//void GetTree(TreeNode& trProperties, int nSubBranchID = 0);
	bool SetTree(TreeNode& trProperties, TreeNode &trChange=NULL);
	void OnAfterSettings(TreeNode& tr);
	void ConstructTree(TreeNode &tr);
	//void GetSelection(Layer& lay);
	string GetSelectionStr();
	
	bool OnAfterValueChange(TreeNode& trRow, int nRow, bool& bUpdateGUI, bool& bInitGUI);
	
	void UpdateTreeShown(TreeNode& tr);

public:
	void ConstructDimensionsTree(TreeNode& tr, int nCols=-1, int nRows=-1, string strXMin="", string strXMax="", string strYMin="", string strYMax="");
	///---- CPY 11/12/05 QA70-8292-3 COL_INTERNAL_DATATYPE_COMPLEX_NOT_WORKING
	//	void ConstructFormatTree(TreeNode& tr, int nInternalDataType=-1, int nDataFormat=-1, int nDisplay=-1, int nDigits=-1);
	//-----
	
protected:
///Kevin 11/12/05 QA70-8292-3 COL_INTERNAL_DATATYPE_COMPLEX_NOT_WORKING
//	int ConvertGUIInternalData(int nInternalData, bool bToGUI=true);
///End COL_INTERNAL_DATATYPE_COMPLEX_NOT_WORKING
};

class MatrixObjectValues : public MatrixObjectAccess
{
public:
	MatrixObjectValues();
	MatrixObjectValues(MatrixLayer& lay);
	~MatrixObjectValues();
	
	//virtual
	bool Attach(DataObject& ob);
	///Jasmine 08/28/06 SHARE_SET_VAL_DLG
	bool IsProcessSelChange(Layer& lay);
	string GetSelectionStr();
	///Kyle 12/08/2008 CHECK_IF_RANGE_SELECTED_DIFFERENT_FROM_FORMULA_RANGE
	//string GetFormula();
	string GetFormula(vector<int>& vnRows = NULL, vector<int>& vnCols = NULL, int* pnColSelWay = NULL);
	///End CHECK_IF_RANGE_SELECTED_DIFFERENT_FROM_FORMULA_RANGE
	bool SetFormula(LPCSTR lpcszFormula, int nAutoUpdate);
	bool ExecuteFormula(BOOL bUndo = TRUE);
	int GetFormulaAutoUpdateMode();
	///End SHARE_SET_VAL_DLG
private:
	MatrixObject		m_matOB;
};

#endif //_DATA_OB_MANAGER_H_
